!	I have distributed this program under the terms of the GPL v2.0,
!	the text of which appears at the end of this file.  The text of
!	the GPL MUST remain with all versions of this program, including
!	any derivative works.  Moving if to its own file (usually named
!	"copying" satisfies this requirement.
!
!
!	Purpose:
!===============================================================================================================
!This is not the fastest such program around but it gave me something to do and if nothing else made me  
!think more about optimization. To compile the program you will need a Fortran 90 compiler and the 
!excellent Winteracter 5.0 Fortran GUI toolkit. It should compile under both Windows and Linux.
!I have compiled the included executable using the Lahey Fortran 95 version compiler 5.7c with the 
! -o1 and -tpp switches therefore the program will only run on Pentium Pro or newer Intel CPU's, or Athlon class 
!and newer AMD processors. This program runs significantly faster on a Pentium 4 system than on an Athlon one.
!The compiled version is restricted to 25 000 000 digits if you would like it to handle more e-mail this 
!sites web master and he will know how to contact me. I originally was going to use dynamic memory 
!allocation but it slowed the execution of the program dramatically :( 
!I don't believe with this type of problem that a higher level language such as C or Fortran can compete 
!with an optimised Assembler program, but they are much easier to read and study. Enjoy!
!
!Thanks to David Gillies for his idea of using look up tables and Ben Despres for hosting the code and
!for answering my question on coding without suggesting I stick to my day job. 
!
!	Record of Revisions:
!	Date		Programmer		Description of Change
!===============================================================================================================
! 	30-06-03	Matt Stenson	Completed I/O and main body of program
! 	01-07-03	Matt Stenson	Managed to get a 40% increase in speed through tuning
! 	01-07-03	Matt Stenson	Added file I/O so the program can be stopped restarted at will
!	02-07-03	Matt Stenson	Changed the addition part to use look up tables to increase speed 
!	15-08-03	Matt Stenson	Finished off a few cosmetic things
!	19-08-03	Matt Stenson	Added the GPL licence and ran the comments through a spell check


      MODULE VARIABLES
!
!   Shared variables for any routine with 'USE VARIABLES'
!
        IMPLICIT NONE
!
        CHARACTER(LEN=256)            :: FNAME = ' ' ,START_NUMBER_STRING   
	INTEGER*4 :: LENGTH,TIME_FLAG,TIME_INT = 0,START_NUMBER,COUNTER = 0, STOP,MILLION_FLAG = 1, &
			FLAG = 1,START_NUMBER_LENGTH,SUCCESS = 0,SAVE_FLAG = 1, CURRENT_MILLION = 0,MILLIONS = 1
	INTEGER*8 :: TIME_HOLDER
	REAL :: TIME     

!
      END MODULE VARIABLES
!
!*****************************************************************************
!
      MODULE INTERFACES
        IMPLICIT NONE
        INTERFACE
          SUBROUTINE ProcessButton(IDENT,QUIT)
            IMPLICIT NONE
            INTEGER, INTENT (IN    ) :: IDENT
            LOGICAL, INTENT (IN OUT) :: QUIT
          END SUBROUTINE ProcessButton
!
          SUBROUTINE Open()
            IMPLICIT NONE
          END SUBROUTINE Open
          SUBROUTINE Start()
          	IMPLICIT NONE
          END SUBROUTINE Start
          SUBROUTINE About()
            IMPLICIT NONE
          END SUBROUTINE About
        END INTERFACE
      END MODULE INTERFACES
!
!*****************************************************************************
!
      PROGRAM PalindromeGUI
!
!
      USE WINTERACTER
      USE INTERFACES
      USE RESOURCE

!
      IMPLICIT NONE
!
!   Type declarations
!
      TYPE(WIN_MESSAGE) :: MESSAGE
!
!   Variable declarations
!
      LOGICAL           :: QUIT  = .FALSE.
      INTEGER           :: ITYPE
!
!   Initialise Winteracter
!
      CALL WInitialise()
!
!   Root window hidden from view
!
      CALL WindowOpen(HideWindow)
!
!   Load and show the main dialog (centred)
!
      CALL WDialogLoad(IDD_DIALOG1)
      CALL WDialogShow(-1,-1,0,Modeless)
      

!
!   Main message loop
!
      DO WHILE(.NOT.QUIT)
        CALL WMessage(ITYPE,MESSAGE)
        SELECT CASE (ITYPE)
          CASE (PushButton)
            CALL ProcessButton(MESSAGE%VALUE1,QUIT)
        END SELECT
      END DO
!
!   Close program
!
      CALL WindowClose()
!
      STOP
      END PROGRAM PalindromeGUI
!
!*****************************************************************************
!
      SUBROUTINE ProcessButton(IDENT,QUIT)
!
!   This subroutine processes button selection
!
      USE WINTERACTER
      USE INTERFACES
      USE RESOURCE
!
      IMPLICIT NONE
!
      INTEGER, INTENT (IN)     :: IDENT
      LOGICAL, INTENT (IN OUT) :: QUIT
!
!   Branch depending on chosen button
!
      SELECT CASE (IDENT)
        CASE (ID_FILE_OPEN)
          CALL Open()
        CASE (ID_HELP_ABOUT)
          CALL About()
        CASE (IDF_CLEAR)
          CALL Clear()
        CASE (ID_START)
          CALL Start()
        CASE (ID_FILE_EXIT,IDCANCEL)
          QUIT = .TRUE.
      END SELECT
!
      RETURN
      END SUBROUTINE ProcessButton
!
!*****************************************************************************
!
      SUBROUTINE Open()
!
!   This subroutine processes File|Open
!
      USE WINTERACTER
      USE VARIABLES
      USE RESOURCE
!
      IMPLICIT NONE
!
      CHARACTER(LEN=256) :: FILTER
      INTEGER            :: IFLAGS,I,IERROR
!
      IFLAGS = LoadDialog + MustExist
      FILTER = 'CheckPoint Files|*.chk|All files|*.*|'
      CALL WSelectFile(FILTER,IFLAGS,FNAME,'Open File')

!
	IF (FNAME /= ' ') THEN
	CALL WDialogPutString(IDF_SAVE_FILE,' ')
	CALL WDialogPutInteger(IDF_STOP_ITERATION,0)
	CALL WDialogPutInteger(IDF_ITERATIONS,0)
	CALL WDialogPutInteger(IDF_DIGITS,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_SECONDS,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_MINUTES,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_HOURS,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_DAYS,0)
	CALL WdialogPutString(IDF_STATUS,'')	


	COUNTER = 0
	LENGTH = 0
	SUCCESS = 0
	TIME_INT = 0
	COUNTER = 0
	STOP = 0
	MILLION_FLAG = 1
	FLAG = 1
	START_NUMBER_LENGTH = 0
	TIME_HOLDER = 0
	CURRENT_MILLION = 0
	MILLIONS = 1
	
		OPEN(7,FILE = FNAME, STATUS = 'UNKNOWN',IOSTAT=IERROR,ACTION = 'READ')
		IF (IERROR == 1) THEN
			RETURN
		END IF
		CALL WdialogPutString(IDF_SAVE_FILE,FNAME)

		READ(7,'(T17,I)')FLAG
		READ(7,'(T19,I)')START_NUMBER
		READ(7,'(T19,I)')COUNTER
		READ(7,'(T19,I)')LENGTH
		CALL WDialogPutInteger(IDF_ITERATIONS,COUNTER)
		CALL WDialogPutInteger(IDF_DIGITS,LENGTH)
		CALL WDialogPutInteger(IDF_START_INTEGER,START_NUMBER)
		CALL WDialogFieldState(IDF_START_INTEGER,2)
		SUCCESS = 0
		CLOSE(7)

	END IF

      RETURN
      END SUBROUTINE Open
!
!*****************************************************************************
!
      SUBROUTINE Clear()
!
!   This subroutine processes the Clear Option
!
      USE WINTERACTER
      USE VARIABLES
      USE RESOURCE
!
      IMPLICIT NONE
	
	CALL WDialogPutInteger(IDF_SAVE_INTERVAL,120)
	CALL WDialogPutString(IDF_SAVE_FILE,' ')
	CALL WDialogPutInteger(IDF_STOP_ITERATION,0)
	CALL WDialogPutInteger(IDF_ITERATIONS,0)
	CALL WDialogPutInteger(IDF_DIGITS,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_SECONDS,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_MINUTES,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_HOURS,0)
	CALL WDialogPutInteger(IDF_CPU_TIME_DAYS,0)
	CALL WDialogPutInteger(IDF_START_INTEGER,196)
	CALL WDialogFieldState(IDF_START_INTEGER,1)
	CALL WdialogPutString(IDF_STATUS,'')
	FNAME = ' '
	COUNTER = 0
	LENGTH = 0
	START_NUMBER = 196
	SUCCESS = 0
	TIME_INT = 0
	COUNTER = 0
	STOP = 0
	MILLION_FLAG = 1
	FLAG = 1
	START_NUMBER_LENGTH = 0
	TIME_HOLDER = 0	
	CURRENT_MILLION = 0
	MILLIONS = 1
	
	
      RETURN
      END SUBROUTINE Clear
!
!*****************************************************************************!
      SUBROUTINE About()
!
!   This subroutine processes the About option
!
      USE WINTERACTER
      USE RESOURCE
!
      IMPLICIT NONE
!
      CHARACTER(LEN=512)  :: CABOUT
!
!   Set About message
!
      CABOUT = 'This program was written by Matt Stenson July 2003.'
!
!   Load and show the modal about dialog
!
      CALL WDialogLoad(IDD_ABOUT)
      CALL WDialogPutString(ID_LABEL1,CABOUT)
      CALL WDialogShow(-1,-1,0,Modal)
      CALL WDialogUnload()
!
      RETURN
      END SUBROUTINE About
!*****************************************************************************
!
      SUBROUTINE Start()


      
      USE WINTERACTER
      USE RESOURCE
      USE VARIABLES
      

      IMPLICIT NONE 
	!Allocate two large 1D integer arrays
	!If you allocate them as *2 or *1 use save more memory but take a real performance hit
	INTEGER*4, DIMENSION(-1:25000100) ::temp1
	INTEGER*4, DIMENSION(-1:25000100) ::temp2
	INTEGER*4 :: IERROR,COUNTERS
	INTEGER*8 ::  I, J 
        !Initialise look-up tables
	INTEGER*4, DIMENSION(0:20) :: REMAINDER = (/0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0/)
	INTEGER*4, DIMENSION(0:20) :: CARRY = (/0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2/)
	TYPE(WIN_MESSAGE) :: MESG
	INTEGER*4 :: ITYPE,LENGTH_DATE,LENGTH_START,LENGTH_TIME,LENGTH_COUNTER
	CHARACTER(LEN=32) :: DATE,TIME_STRING,COUNTER_STRING


CALL WDialogGetInteger(IDF_SAVE_INTERVAL,TIME_FLAG)
CALL WDialogGetString(IDF_SAVE_FILE,FNAME)
CALL WDialogGetInteger(IDF_STOP_ITERATION,STOP)
CALL WdialogPutString(IDF_STATUS,'Searching ===>')

FLAG = (TIME_INT/TIME_FLAG)

!Check to see if a checkpoint file is selected and open it


!If no check point is selected then start from scratch
IF (FNAME == ' ') THEN	
	CALL WDialogGetInteger(IDF_START_INTEGER,START_NUMBER)
	OPEN(8, STATUS = 'SCRATCH',IOSTAT=IERROR)
		IF (IERROR == 1) THEN
			RETURN
		END IF	
	WRITE(8,*)START_NUMBER
	REWIND(UNIT = 8)	
	READ(8,*)START_NUMBER_STRING
	START_NUMBER_STRING = ADJUSTL(START_NUMBER_STRING)
	START_NUMBER_LENGTH = LEN_TRIM(START_NUMBER_STRING)
	REWIND(UNIT = 8)
	READ(8,110)TEMP1(0:START_NUMBER_LENGTH + 1)
	
	TEMP1(-1) = 0
	TEMP1(0) = 0	
	CALL WDialogFieldState(IDF_START_INTEGER,2)	

110	FORMAT(256(:,I1))	

	CLOSE(8)
	
	LENGTH = START_NUMBER_LENGTH
	
	!Reverse temp1 and place in temp2
	TEMP2(1:LENGTH:1) = TEMP1(LENGTH:1:-1)
	
	

!Checkpoint file is available to open it and pickup where the file left off
ELSE 
		OPEN(7,FILE = FNAME, STATUS = 'UNKNOWN',IOSTAT=IERROR,ACTION = 'READ')
		CALL WdialogPutString(IDF_SAVE_FILE,FNAME)

		READ(7,'(T17,I)')FLAG
		READ(7,'(T19,I)')START_NUMBER
		READ(7,'(T19,I)')COUNTER
		READ(7,'(T19,I)')LENGTH
		CALL WDialogPutInteger(IDF_ITERATIONS,COUNTER)
		CALL WDialogPutInteger(IDF_DIGITS,LENGTH)
		CALL WDialogPutInteger(IDF_START_INTEGER,START_NUMBER)
		CALL WDialogFieldState(IDF_START_INTEGER,2)
		SUCCESS = 0

	TEMP1(-1) = 0
	TEMP1(0) = 0
	
	MILLIONS = (LENGTH / 1000000)
	IF (MILLIONS < 1) THEN
		MILLIONS = 1
	END IF

	READ(7,100)TEMP1(1:LENGTH)
	CLOSE(7)
	
	!Reverse temp1 and place in temp2
	TEMP2(1:LENGTH:1) = TEMP1(LENGTH:1:-1)

END IF

!Core reverse and add routine
!**************************************************************************************************
!**************************************************************************************************
!**************************************************************************************************
!Main loop
DO
	!Work from back of array and add result of (temp1 + temp2) and place into temp1
	I=LENGTH
	
	DO
		TEMP1(I) = TEMP1(I) + TEMP2(I) 
		!Here's where we use the lookup tables to speed up addition.
		TEMP1(I - 1) = (CARRY(TEMP1(I)) + TEMP1(I - 1))
		TEMP1(I) = REMAINDER(TEMP1(I))	
		
		!Check to see if we are at beginning of the array and if so exit
		IF (I == 1) THEN
			EXIT
		END IF
		
		I = I - 1
		
	END DO


	!Check to see if the new number is one digit longer and if so move all the digits down one place, 
	!reset everything and advance the number of digits by 1
	IF ((TEMP1(0) == 1).OR.(TEMP1(0) == 2)) THEN
		LENGTH = LENGTH + 1
		TEMP1(1:LENGTH:1) = TEMP1(0:(LENGTH-1):1)
		TEMP1(-1) = 0
		TEMP1(0) = 0
		CURRENT_MILLION = 0
	END IF	

	!Reverse temp1 into temp2
	TEMP2(1:LENGTH:1) = TEMP1(LENGTH:1:-1)	

	!Reset I
	I=0

	!Advance the counter of total iterations
	COUNTER = COUNTER + 1
!**************************************************************************************************
!**************************************************************************************************
!**************************************************************************************************	
	
	!Check to see if we have a PalIndrome by advancing from left to right
	!through both temp1 and temp2 and comparing. As soon as they don't match 
	!we don't have a Palindrome so exit and do another iteration
	DO
		I = I + 1
		IF (TEMP1(I) /= TEMP2(I)) THEN
			EXIT
		END IF
		!We have a Palindrome so notify the user and exit
		IF (I == LENGTH)THEN		
			!Write a Palindrome file
			!Do the messy business of getting all the info needed to make a unique file name
			CALL IntegerToString(START_NUMBER,START_NUMBER_STRING,'(I32)')
			START_NUMBER_STRING = ADJUSTL(START_NUMBER_STRING)
			LENGTH_START = LEN_TRIM(START_NUMBER_STRING)
			CALL DATE_AND_TIME(DATE)	
			DATE = ADJUSTL(DATE)	
			LENGTH_DATE = LEN_TRIM(DATE)
			CALL IntegerToString(COUNTER,COUNTER_STRING,'(I32)')
			COUNTER_STRING = ADJUSTL(COUNTER_STRING)
			LENGTH_COUNTER = LEN_TRIM(COUNTER_STRING)			
			OPEN(7,FILE = START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))&
			//'.palindrome', STATUS = 'REPLACE')
			WRITE(7,*)'Automatic save',FLAG
			WRITE(7,*)'Initial value:  ',START_NUMBER
			WRITE(7,*)'Iteration:      ',COUNTER
			WRITE(7,*)'Number of digits',LENGTH
			
			WRITE(7,100)TEMP1(1:LENGTH)
			
			CLOSE(7)	
			CALL WdialogPutString(IDF_SAVE_FILE,START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))//'.palindrome')
			
			SUCCESS = 1
			CALL WdialogPutString(IDF_STATUS,'Palindrome Found! :)')
			CALL WDialogPutInteger(IDF_ITERATIONS,(COUNTER))
			CALL WDialogPutInteger(IDF_DIGITS,(length))	
			
			EXIT
		END IF
	END DO
	IF (SUCCESS == 1) THEN
		EXIT
	END IF
	
	!If the user pushes the stop button then write a checkpoint file and pause
	CALL WMessagePeek(ITYPE,MESG)
            SELECT CASE (ITYPE)
              CASE (PushButton)
                  SELECT CASE (MESG%VALUE1)
                                        CASE (ID_STOP)
			!Write a checkpoint file
			CALL WDialogPutInteger(IDF_ITERATIONS,(COUNTER))
			CALL WDialogPutInteger(IDF_DIGITS,(length))	
			CALL WdialogPutString(IDF_STATUS,'Saving Checkpoint File')
			!Do the messy business of getting all the info needed to make a unique file name
			CALL IntegerToString(START_NUMBER,START_NUMBER_STRING,'(I32)')
			START_NUMBER_STRING = ADJUSTL(START_NUMBER_STRING)
			LENGTH_START = LEN_TRIM(START_NUMBER_STRING)
			CALL DATE_AND_TIME(DATE)	
			DATE = ADJUSTL(DATE)	
			LENGTH_DATE = LEN_TRIM(DATE)
			CALL IntegerToString(COUNTER,COUNTER_STRING,'(I32)')
			COUNTER_STRING = ADJUSTL(COUNTER_STRING)
			LENGTH_COUNTER = LEN_TRIM(COUNTER_STRING)		
			
			OPEN(7,FILE = START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))&
			//'.chk', STATUS = 'REPLACE')
			WRITE(7,*)'Automatic save',FLAG
			WRITE(7,*)'Initial value:  ',START_NUMBER
			WRITE(7,*)'Iteration:      ',COUNTER
			WRITE(7,*)'Number of digits',LENGTH
			
			WRITE(7,100)TEMP1(1:LENGTH)
			
			CLOSE(7)
			CALL WdialogPutString(IDF_SAVE_FILE,START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))//'.chk')
			
			CALL WdialogPutString(IDF_STATUS,'')
			
			EXIT
	
                  END SELECT
          	END SELECT
	
	CALL CPU_TIME(TIME)
	TIME_INT = INT(TIME)
	IF (TIME_HOLDER < TIME_INT) THEN
		CALL	WDialogPutInteger(IDF_CPU_TIME_SECONDS,TIME_INT)
		CALL	WDialogPutInteger(IDF_CPU_TIME_MINUTES,(TIME_INT/60))
		CALL	WDialogPutInteger(IDF_CPU_TIME_HOURS,(TIME_INT/3600))
		CALL	WDialogPutInteger(IDF_CPU_TIME_DAYS,(TIME_INT/86400))
		TIME_HOLDER = TIME_INT
	END IF
	
	IF (((COUNTER == STOP).AND.(STOP /= 0)).OR.(LENGTH == 25000000)) THEN
		!If we reach the end of the array or we reach the users stop iteration write the current results to a file and exit
		CALL WDialogPutInteger(IDF_ITERATIONS,(COUNTER))
		CALL WDialogPutInteger(IDF_DIGITS,(length))	
		CALL WdialogPutString(IDF_STATUS,'Saving Checkpoint File')
		!Do the messy business of getting all the info needed to make a unique file name
		CALL IntegerToString(START_NUMBER,START_NUMBER_STRING,'(I32)')
		START_NUMBER_STRING = ADJUSTL(START_NUMBER_STRING)
		LENGTH_START = LEN_TRIM(START_NUMBER_STRING)
		CALL DATE_AND_TIME(DATE)	
		DATE = ADJUSTL(DATE)	
		LENGTH_DATE = LEN_TRIM(DATE)
		CALL IntegerToString(COUNTER,COUNTER_STRING,'(I32)')
		COUNTER_STRING = ADJUSTL(COUNTER_STRING)
		LENGTH_COUNTER = LEN_TRIM(COUNTER_STRING)	
		
		OPEN(7,FILE = START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
		//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))&
		//'.chk', STATUS = 'REPLACE')
		WRITE(7,*)'Automatic save',FLAG
		WRITE(7,*)'Initial value:  ',START_NUMBER
		WRITE(7,*)'Iteration:      ',COUNTER
		WRITE(7,*)'Number of digits',LENGTH
			
		WRITE(7,100)TEMP1(1:LENGTH)
			
		CLOSE(7)
			
		CALL WdialogPutString(IDF_SAVE_FILE,START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))//'.chk')

		CALL WdialogPutString(IDF_STATUS,'')
		CALL WDialogPutInteger(IDF_STOP_ITERATION,0)
			
		EXIT
	END IF

	!Write the digit length and number of iterations to the GUI
	IF (COUNTER < 100000) THEN
		IF (COUNTERS == 999) THEN
			CALL	WDialogPutInteger(IDF_ITERATIONS,(COUNTER-1))
			CALL	WDialogPutInteger(IDF_DIGITS,(length))
			COUNTERS = 0
		END IF
	ELSE IF ((COUNTER >= 100000).AND.(COUNTER <= 1000000)) THEN
		IF (COUNTERS == 100) THEN
			CALL	WDialogPutInteger(IDF_ITERATIONS,(COUNTER-1))
			CALL	WDialogPutInteger(IDF_DIGITS,(length))
			COUNTERS = 0
		END IF
	ELSE 
			CALL	WDialogPutInteger(IDF_ITERATIONS,(COUNTER))
			CALL	WDialogPutInteger(IDF_DIGITS,(length))
	END IF
	COUNTERS = COUNTERS + 1
	
	!Stops the program from writing the million digit files twice if the number does not grow in length on the next iteration
	IF ((LENGTH == (1000000 * MILLIONS)).AND.(CURRENT_MILLION /= 2))THEN
		CURRENT_MILLION = 1
	END IF
	
	!Automated counter to let the user know progress and write current output to a file
	!Writes to a file at the user specified interval and every million digits
	IF((((TIME_INT/60) == (TIME_FLAG * SAVE_FLAG)).AND.(SAVE_FLAG > 0)).OR.((LENGTH == (1000000 * MILLIONS)).AND.(CURRENT_MILLION == 1))) THEN
	
		CALL WdialogPutString(IDF_STATUS,'Saving Checkpoint File')	
		!Write a checkpoint file
		!Do the messy business of getting all the info needed to make a unique file name
		CALL IntegerToString(START_NUMBER,START_NUMBER_STRING,'(I32)')
		START_NUMBER_STRING = ADJUSTL(START_NUMBER_STRING)
		LENGTH_START = LEN_TRIM(START_NUMBER_STRING)
		CALL DATE_AND_TIME(DATE)	
		DATE = ADJUSTL(DATE)	
		LENGTH_DATE = LEN_TRIM(DATE)
		CALL IntegerToString(COUNTER,COUNTER_STRING,'(I32)')
		COUNTER_STRING = ADJUSTL(COUNTER_STRING)
		LENGTH_COUNTER = LEN_TRIM(COUNTER_STRING)
		IF ((LENGTH == (1000000 * MILLIONS)).AND.(CURRENT_MILLION == 1)) THEN
			OPEN(7,FILE = START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))&
			//'.million', STATUS = 'REPLACE')
		CALL WdialogPutString(IDF_SAVE_FILE,START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))//'.million')			
		ELSE
			OPEN(7,FILE = START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))&
			//'.chk', STATUS = 'REPLACE')
		CALL WdialogPutString(IDF_SAVE_FILE,START_NUMBER_STRING(1:(LENGTH_START))//'_'//COUNTER_STRING(1:(LENGTH_COUNTER))//'_'&
			//DATE(7:(LENGTH_DATE))//'-'//DATE(5:(LENGTH_DATE-2))//'-'//DATE(1:(LENGTH_DATE-4))//'.chk')
		SAVE_FLAG = SAVE_FLAG + 1
		FLAG = FLAG + 1
		END IF
		WRITE(7,*)'Automatic save',FLAG
		WRITE(7,*)'Initial value:  ',START_NUMBER
		WRITE(7,*)'Iteration:      ',COUNTER
		WRITE(7,*)'Number of digits',LENGTH
			
		WRITE(7,100)TEMP1(1:LENGTH)
			
		CLOSE(7)

		

		CALL WdialogPutString(IDF_STATUS,'Searching ===>')

		
		IF (LENGTH == (1000000 * MILLIONS)) THEN
			MILLIONS = MILLIONS + 1
			CURRENT_MILLION = 2
		END IF
		
100	FORMAT(70(:,I1))
	END IF
		

END DO


      RETURN
      END SUBROUTINE Start
      
!	---------------------------------------------------------------------------
!
! 	                   GNU GENERAL PUBLIC LICENSE
! 	                      Version 2, June 1991
!
!	 Copyright (!) 1989, 1991 Free Software Foundation, Inc.
!	     59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!	 Everyone is permitted to copy and distribute verbatim copies
!	of this license document, but changing it is not allowed.
!
!	                           Preamble
!
!	 The licenses for most software are designed to take away your
!	freedom to share and change it.  By contrast, the GNU General Public
!	License is intended to guarantee your freedom to share and change free
!	software--to make sure the software is free for all its users.  This
!	General Public License applies to most of the Free Software
!	Foundation's software and to any other program whose authors commit to
!	using it.  (Some other Free Software Foundation software is covered by
!	the GNU Library General Public License instead.)  You can apply it to
!	your programs, too.
!
!	  When we speak of free software, we are referring to freedom, not
!	price.  Our General Public Licenses are designed to make sure that you
!	have the freedom to distribute copies of free software (and charge for
!	this service if you wish), that you receive source code or can get it
!	if you want it, that you can change the software or use pieces of it
!	in new free programs; and that you know you can do these things.
!
!	  To protect your rights, we need to make restrictions that forbid
!	anyone to deny you these rights or to ask you to surrender the rights.
!	These restrictions translate to certain responsibilities for you if you
!	distribute copies of the software, or if you modify it.
!
!	  For example, if you distribute copies of such a program, whether
!	gratis or for a fee, you must give the recipients all the rights that
!	you have.  You must make sure that they, too, receive or can get the
!	source code.  And you must show them these terms so they know their
!	rights.
!
!	  We protect your rights with two steps: (1) copyright the software, and
!	(2) offer you this license which gives you legal permission to copy,
!	distribute and/or modify the software.
!
!	  Also, for each author's protection and ours, we want to make certain
!	that everyone understands that there is no warranty for this free
!	software.  If the software is modified by someone else and passed on, we
!	want its recipients to know that what they have is not the original, so
!	that any problems introduced by others will not reflect on the original
!	authors' reputations.
!
!	  Finally, any free program is threatened constantly by software
!	patents.  We wish to avoid the danger that redistributors of a free
!	program will individually obtain patent licenses, in effect making the
!	program proprietary.  To prevent this, we have made it clear that any
!	patent must be licensed for everyone's free use or not licensed at all.
!
!	  The precise terms and conditions for copying, distribution and
!	modification follow.
!
!	                   GNU GENERAL PUBLIC LICENSE
!	  TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
!
!	  0. This License applies to any program or other work which contains
!	a notice placed by the copyright holder saying it may be distributed
!	under the terms of this General Public License.  The "Program", below,
!	refers to any such program or work, and a "work based on the Program"
!	means either the Program or any derivative work under copyright law:
!	that is to say, a work containing the Program or a portion of it,
!	either verbatim or with modifications and/or translated into another
!	language.  (Hereinafter, translation is included without limitation in
!	the term "modification".)  Each licensee is addressed as "you".
!
!	Activities other than copying, distribution and modification are not
!	covered by this License; they are outside its scope.  The act of
!	running the Program is not restricted, and the output from the Program
!	is covered only if its contents constitute a work based on the
!	Program (independent of having been made by running the Program).
!	Whether that is true depends on what the Program does.
!
!	  1. You may copy and distribute verbatim copies of the Program's
!	source code as you receive it, in any medium, provided that you
!	conspicuously and appropriately publish on each copy an appropriate
!	copyright notice and disclaimer of warranty; keep intact all the
!	notices that refer to this License and to the absence of any warranty;
!	and give any other recipients of the Program a copy of this License
!	along with the Program.
!
!	You may charge a fee for the physical act of transferring a copy, and
!	you may at your option offer warranty protection in exchange for a fee.
!
!	  2. You may modify your copy or copies of the Program or any portion
!	of it, thus forming a work based on the Program, and copy and
!	distribute such modifications or work under the terms of Section 1
!	above, provided that you also meet all of these conditions:
!
!	    a) You must cause the modified files to carry prominent notices
!	    stating that you changed the files and the date of any change.
!
!	    b) You must cause any work that you distribute or publish, that in
!	    whole or in part contains or is derived from the Program or any
!	    part thereof, to be licensed as a whole at no charge to all third
!	    parties under the terms of this License.
!
!	    c) If the modified program normally reads commands interactively
!	    when run, you must cause it, when started running for such
!	    interactive use in the most ordinary way, to print or display an
!	    announcement including an appropriate copyright notice and a
!	    notice that there is no warranty (or else, saying that you provide
!	    a warranty) and that users may redistribute the program under
!	    these conditions, and telling the user how to view a copy of this
!	    License.  (Exception: if the Program itself is interactive but
!	does not normally print such an announcement, your work based on
!	    the Program is not required to print an announcement.)
!
!	These requirements apply to the modified work as a whole.  If
!	identifiable sections of that work are not derived from the Program,
!	and can be reasonably considered independent and separate works in
!	themselves, then this License, and its terms, do not apply to those
!	sections when you distribute them as separate works.  But when you
!	distribute the same sections as part of a whole which is a work based
!	on the Program, the distribution of the whole must be on the terms of
!	this License, whose permissions for other licensees extend to the
!	entire whole, and thus to each and every part regardless of who wrote it.
!
!	Thus, it is not the intent of this section to claim rights or contest
!	your rights to work written entirely by you; rather, the intent is to
!	exercise the right to control the distribution of derivative or
!	collective works based on the Program.
!
!	In addition, mere aggregation of another work not based on the Program
!	with the Program (or with a work based on the Program) on a volume of
!	a storage or distribution medium does not bring the other work under
!	the scope of this License.
!
!	  3. You may copy and distribute the Program (or a work based on it,
!	under Section 2) in object code or executable form under the terms of
!	Sections 1 and 2 above provided that you also do one of the following:
!
!	    a) Accompany it with the complete corresponding machine-readable
!	    source code, which must be distributed under the terms of Sections
!	    1 and 2 above on a medium customarily used for software interchange; or,
!
!	    b) Accompany it with a written offer, valid for at least three
!	    years, to give any third party, for a charge no more than your
!	    cost of physically performing source distribution, a complete
!	    machine-readable copy of the corresponding source code, to be
!	    distributed under the terms of Sections 1 and 2 above on a medium
!	    customarily used for software interchange; or,
!
!	    c) Accompany it with the information you received as to the offer
!	    to distribute corresponding source code.  (This alternative is
!	    allowed only for noncommercial distribution and only if you
!	    received the program in object code or executable form with such
!	    an offer, in accord with Subsection b above.)
!
!	The source code for a work means the preferred form of the work for
!	making modifications to it.  For an executable work, complete source
!	code means all the source code for all modules it contains, plus any
!	associated interface definition files, plus the scripts used to
!	control compilation and installation of the executable.  However, as a
!	special exception, the source code distributed need not include
!	anything that is normally distributed (in either source or binary
!	form) with the major components (compiler, kernel, and so on) of the
!	operating system on which the executable runs, unless that component
!	itself accompanies the executable.
!
!	If distribution of executable or object code is made by offering
!	access to copy from a designated place, then offering equivalent
!	access to copy the source code from the same place counts as
!	distribution of the source code, even though third parties are not
!	compelled to copy the source along with the object code.
!
!	  4. You may not copy, modify, sublicense, or distribute the Program
!	except as expressly provided under this License.  Any attempt
!	otherwise to copy, modify, sublicense or distribute the Program is
!	void, and will automatically terminate your rights under this License.
!	However, parties who have received copies, or rights, from you under
!	this License will not have their licenses terminated so long as such
!	parties remain in full compliance.
!
!	  5. You are not required to accept this License, since you have not
!	signed it.  However, nothing else grants you permission to modify or
!	distribute the Program or its derivative works.  These actions are
!	prohibited by law if you do not accept this License.  Therefore, by
!	modifying or distributing the Program (or any work based on the
!	Program), you indicate your acceptance of this License to do so, and
!	all its terms and conditions for copying, distributing or modifying
!	the Program or works based on it.
!
!	  6. Each time you redistribute the Program (or any work based on the
!	Program), the recipient automatically receives a license from the
!	original licensor to copy, distribute or modify the Program subject to
!	these terms and conditions.  You may not impose any further
!	restrictions on the recipients' exercise of the rights granted herein.
!	You are not responsible for enforcing compliance by third parties to
!	this License.
!
!	  7. If, as a consequence of a court judgment or allegation of patent
!	infringement or for any other reason (not limited to patent issues),
!	conditions are imposed on you (whether by court order, agreement or
!	otherwise) that contradict the conditions of this License, they do not
!	excuse you from the conditions of this License.  If you cannot
!	distribute so as to satisfy simultaneously your obligations under this
!	License and any other pertinent obligations, then as a consequence you
!	may not distribute the Program at all.  For example, if a patent
!	license would not permit royalty-free redistribution of the Program by
!	all those who receive copies directly or indirectly through you, then
!	the only way you could satisfy both it and this License would be to
!	refrain entirely from distribution of the Program.
!
!	If any portion of this section is held invalid or unenforceable under
!	any particular circumstance, the balance of the section is intended to
!	apply and the section as a whole is intended to apply in other
!	circumstances.
!
!	It is not the purpose of this section to induce you to infringe any
!	patents or other property right claims or to contest validity of any
!	such claims; this section has the sole purpose of protecting the
!	integrity of the free software distribution system, which is
!	implemented by public license practices.  Many people have made
!	generous contributions to the wide range of software distributed
!	through that system in reliance on consistent application of that
!	system; it is up to the author/donor to decide if he or she is willing
!	to distribute software through any other system and a licensee cannot
!	impose that choice.
!
!	This section is intended to make thoroughly clear what is believed to
!	be a consequence of the rest of this License.
!
!	  8. If the distribution and/or use of the Program is restricted in
!	certain countries either by patents or by copyrighted interfaces, the
!	original copyright holder who places the Program under this License
!	may add an explicit geographical distribution limitation excluding
!	those countries, so that distribution is permitted only in or among
!	countries not thus excluded.  In such case, this License incorporates
!	the limitation as if written in the body of this License.
!
!	  9. The Free Software Foundation may publish revised and/or new versions
!	of the General Public License from time to time.  Such new versions will
!	be similar in spirit to the present version, but may differ in detail to
!	address new problems or concerns.
!
!	Each version is given a distinguishing version number.  If the Program
!	specifies a version number of this License which applies to it and "any
!	later version", you have the option of following the terms and conditions
!	either of that version or of any later version published by the Free
!	Software Foundation.  If the Program does not specify a version number of
!	this License, you may choose any version ever published by the Free Software
!	Foundation.
!
!	  10. If you wish to incorporate parts of the Program into other free
!	programs whose distribution conditions are different, write to the author
!	to ask for permission.  For software which is copyrighted by the Free
!	Software Foundation, write to the Free Software Foundation; we sometimes
!	make exceptions for this.  Our decision will be guided by the two goals
!	of preserving the free status of all derivatives of our free software and
!	of promoting the sharing and reuse of software generally.
!
!                           NO WARRANTY
!
!	  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
!	FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
!	OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
!	PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
!	OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
!	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
!	TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
!	PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
!	REPAIR OR CORRECTION.
!
!	 12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
!	WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
!	REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
!	INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
!	OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
!	TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
!	YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
!	PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
!	POSSIBILITY OF SUCH DAMAGES.
!
!
!                    END OF TERMS AND CONDITIONS
!
!	---------------------------------------------------------------------------      